function init()
    m.top.setFocus(true)
    loadRefreshToken()
    m.providerURL = getProviderFromSection()
    m.user = getUserFromSection()
    m.vodName = getVodName()
    m.Video = m.top.findNode("Video")
    m.deviceInfo = CreateObject("roDeviceInfo")
    getVODDetails()
end function

function getVODDetails()
    m.VODDetails = CreateObject("roSGNode", "VODDetailsTask")
    m.VODDetails.providerURL = m.providerURL
    m.VODDetails.email = m.user.email
    m.VODDetails.user = m.user.username
    m.VODDetails.vodName = m.vodName
    m.VODDetails.control = "RUN"
    m.VODDetails.observeField("VODDetailsDTO", "VODDetailsDTOListener")
end function

function VODDetailsDTOListener()
    if m.VODDetails.VODDetailsDTO = invalid then return invalid
    if m.VODDetails.VODDetailsDTO.status = "NOT_FOUND" then return invalid
    m.vodDetailsDTO = m.VODDetails.VODDetailsDTO.data
    loadVODDetails()
end function

function loadRefreshToken()
    m.authRefreshTokenTask = m.top.findNode("AuthRefreshTokenTask")
    m.authRefreshTokenTask.observeField("authResponseDTO", "refreshTokenListener")
    m.authRefreshTokenTask.control = "RUN"
end function

function refreshTokenListener()
    if m.authRefreshTokenTask <> invalid
        response = ParseJson(m.authRefreshTokenTask.authResponseDTO)
        print("Status: " + response.status)
        if response.status = "ok"
            print("Refreshing token...")
            user = getUserFromSection()
            print("Current token: " + user.token)
            print("New token: " + response.data.token)
            user.token = response.data.token
            user.economic = response.data.economic
            user.expire = response.data.expire
            user.lifetime = response.data.lifetime
            user.parental = response.data.parental
            user.parpass = response.data.parpass
            user.rating = response.data.rating
            user.svod = response.data.svod
            user.validated_email = response.data.validated_email
            setUserOnSection(FormatJson(user))
            refreshTokenFrequency()
            print("Token refreshed.")
        else
            print("Removing user from section.")
            print(response.msg)
            deleteUserOnSection()
            print("Redirecting user to ProviderSelectionScene.")
            redirectScreenTo("ProviderSelectionScene")
        end if
    end if

end function

function refreshTokenFrequency()
    if m.user.lifetime = invalid then m.user.lifetime = 0
    duration = cint(m.user.lifetime / 5)
    if duration <= 60 then duration = 60

    print "duration";duration
    m.timer = CreateObject("roSGNode", "Timer")
    m.timer.id = "timeRefresh"
    m.timer.repeat = false
    m.timer.duration = duration
    m.timer.ObserveField("fire", "refreshTokenFrequencyListener")
    m.timer.control = "start"

end function

function refreshTokenFrequencyListener()
    print "refreshTokenFrequencyListener"
    refreshTokenListener()
    m.content.token = m.user.token
    m.content.startPosition = m.Video.seek
    setHLSContent(m.content)
    refreshPlay(m.content.startPosition)
end function

function refreshPlay(lastSeek) as void
    m.Video.control = "stop"
    m.Video.seek = lastSeek
    m.Video.control = "play"
end function

function contentDTO(title as string, url as string, poster as string, startPosition as integer, size as integer, actors as string, categories as string, token as string, ageRating as string)
    return {
        title: title,
        url: url,
        poster: poster,
        size: size
        startPosition: startPosition,
        actors: actors
        categories: categories
        token: token
        ageRating: ageRating
    }
end function

function setHLSContent(content) as void
    ContentNode = CreateObject("roSGNode", "ContentNode")
    print "content ";content
    ContentNode.streamFormat = "hls"
    ContentNode.HDPosterUrl = content.poster
    ContentNode.SDPosterUrl = content.poster
    ContentNode.FHDPosterUrl = content.poster
    ContentNode.url = content.url + content.token
    ContentNode.title = "(*) Menu | " + content.title
    ContentNode.SDBifUrl = "https://" + m.providerURL + "/media/v/" + m.vodName + "/" + m.vodName + "-sd.bif?t=" + content.token
    ContentNode.HDBifUrl = "https://" + m.providerURL + "/media/v/" + m.vodName + "/" + m.vodName + "-hd.bif?t=" + content.token
    ContentNode.FHDBifUrl = "https://" + m.providerURL + "/media/v/" + m.vodName + "/" + m.vodName + "-fhd.bif?t=" + content.token
    ContentNode.ContentType = "movie"
    ContentNode.categories = content.categories
    ContentNode.IgnoreStreamErrors = true
    ContentNode.AdaptiveMinStartBitrate = 0
    ' ContentNode.ClosedCaptions = true
    ContentNode.PlayStart = content.startPosition
    print "ContentNode ";ContentNode
    m.Video.content = ContentNode
end function

function play()
    m.Video.visible = true
    m.Video.control = "play"
    m.Video.seek = m.Video.content.PlayStart
    ' m.Video.globalCaptionMode = "On"
    m.top.setFocus(false)
    m.Video.setFocus(true)
    m.Video.visible = true
    m.Video.ObserveField("state", "stateListener")
    m.Video.ObserveField("position", "seekListener")
end function

function shouldUpdateWatchingTime() as boolean
    return Cint(m.Video.position) mod 15 = 0
end function

function seekListener()
    if shouldUpdateWatchingTime()
        updateWatchingTime(m.Video.position, m.vodName)
    end if
end function

function updateWatchingTime(time, vodName) as void
    m.updateWatchingTimeTask = m.top.findNode("UpdateWatchingTimeTask")
    m.updateWatchingTimeTask.providerURL = m.providerURL
    m.updateWatchingTimeTask.email = m.user.email
    m.updateWatchingTimeTask.profileId = "1"
    m.updateWatchingTimeTask.time = time
    m.updateWatchingTimeTask.vodName = vodName
    m.updateWatchingTimeTask.control = "RUN"
    m.Video.setFocus(true)
end function

function stateListener()
    if m.Video.state = "error"
        print "Content"; m.Video.content
        print "errorCode: ";m.Video.errorCode
        print "errorStr: "; m.Video.errorStr
        print "errorInfo: "; m.Video.errorInfo
        print "errorMsg: "; m.Video.errorMsg

        dialog = createObject("roSGNode", "Dialog")
        dialog.id = "playerError"
        dialog.title = tr("Erro ao carregar conteúdo")
        dialog.message = tr("Não foi possível carregar, tente novamente mais tarde.") + " Code: " + Str(m.Video.errorCode)
        showDialog(dialog)
    end if

end function

function loadVODDetails()
    m.mode = m.deviceInfo.GetCaptionsMode()
    m.deviceInfo.SetCaptionsMode(m.mode)

    if m.vodDetailsDTO.vodType = "SINGLEMEDIA"
        if m.vodDetailsDTO.watching_time = invalid then m.vodDetailsDTO.watching_time = 0
        m.content = contentDTO(m.vodDetailsDTO.title, "https://" + m.providerURL + m.vodDetailsDTO.playlist + "&t=", m.vodDetailsDTO.poster, m.vodDetailsDTO.watching_time, 0, "", "", m.user.token, m.vodDetailsDTO.ageRating)
    else
        vod = getVODFromSelectedSeasonEpisode(m.vodName)
        if vod = invalid
            redirectScreenTo("VodsScene")
            return invalid 
        else
            watching_time = 0
            if IsString(vod.watching_time) then watching_time = vod.watching_time.ToInt()
            posterUrl = "https://" + m.providerURL + "/images/" + vod.name + "_poster.jpg_280_280"
            m.content = contentDTO(vod.metadata.portugueseTitle, "https://" + m.providerURL + vod.playlist + "&t=", posterUrl, watching_time, 0, "", m.vodDetailsDTO.genres, m.user.token, vod.metadata.ageRating)
        endif
        
    end if

    if shouldCheckParentalControl(m.content.ageRating.toInt())
        checkParentalControl()
    else
        playContent()
    end if

end function

function playContent()
    setHLSContent(m.content)
    play()
end function

function shouldCheckParentalControl(age) as boolean
    return age > m.user.rating
end function

function checkParentalControl()
    m.parentalControlPinPad = m.top.findNode("parentalControlPinPad")
    m.parentalControlBody = m.top.findNode("parentalControlBody")
    m.parentalControlBody.visible = true
    m.parentalControlPinPad.setFocus(true)
    m.parentalControlPinPad.observeField("pin", "pinPadTextChangeListener")
end function

function pinPadTextChangeListener()
    if len(m.parentalControlPinPad.pin) < 4 then return invalid

    pinToSHA1 = convertToSHA1(m.parentalControlPinPad.pin)

    if m.user.parpass <> pinToSHA1
        m.parentalControlPinPad.pin = ""
        m.pinErrorMsg = m.top.findNode("pinErrorMsg")
        m.pinErrorMsg.visible = true
        return invalid
    end if

    m.parentalControlBody.visible = false
    playContent()
end function

function convertToSHA1(text as string) as string
    bytearray = CreateObject("roByteArray")
    bytearray.FromAsciiString(text)
    digest = CreateObject("roEVPDigest")
    digest.Setup("sha1")
    return digest.Process(bytearray)
end function

function getVODFromSelectedSeasonEpisode(name) as dynamic
    vod = invalid
    for each season in m.vodDetailsDTO.seasonsList
        for each episode in season.episodes
            if episode.vod.name = name
                vod = episode.vod
                exit for
            end if
        end for
        exit for
    end for
    return vod
end function

function autoHideOverlay()
    m.autoHide = CreateObject("roSGNode", "Timer")
    m.autoHide.id = "autoHideOverlay"
    m.autoHide.repeat = false
    m.autoHide.duration = 5
    m.autoHide.control = "start"
    m.autoHide.ObserveField("fire", "autoHideOverlayListener")
end function

function autoHideOverlayListener()
    m.top.setFocus(true)
end function

function getVODDetailsFromSection() as dynamic
    section = CreateObject("roRegistrySection", "Authentication")
    if section.Exists("VODDetailsDTO")
        return parseJSON(section.Read("VODDetailsDTO"))
    end if
    return invalid
end function

function getSeletedSeasonEpisodeFromSection() as dynamic
    section = CreateObject("roRegistrySection", "Authentication")
    if section.Exists("selectedSeasonEpisode")
        return parseJSON(section.Read("selectedSeasonEpisode"))
    end if
    return invalid
end function

function stopVideo()
    m.Video.visible = false
    m.Video.control = "stop"
    m.Video.setFocus(false)
end function

function shouldExitScreen(key) as boolean
    return key = "back"
end function

function exitScreen() as void
    stopVideo()
    redirectScreenTo("VodsScene")
end function

function shouldHideOverlay(key) as boolean
    return key = "back"
end function

function shouldRefocusPlayer(key) as boolean
    return (key = "left" or key = "right" or key = "OK") and not m.Video.hasFocus()
end function

function onKeyEvent(key as string, press as boolean) as boolean
    print "in ChannelScene.xml onKeyEvent ";key;" "; press
    handled = false
    if press
        if shouldExitScreen(key)
            exitScreen()
            handled = true
        else if shouldRefocusPlayer(key)
            m.top.setFocus(false)
            m.Video.setFocus(true)
            handled = true
        else
            handled = true
        end if
    else
        if shouldHideOverlay(key)
            m.Video.setFocus(false)
            m.top.setFocus(true)
            handled = true
        end if
        autoHideOverlay()
    end if
    return handled
end function
