function init()
    m.user = getUserFromSection()
    m.providerURL = getProviderFromSection()
    loadRefreshToken()
    setComponentStyles()
    searchInputListener()

end function

function setComponentStyles()
    m.searchInput = m.top.findNode("searchInput")
    m.searchInput.setFocus(true)
    m.searchInput.observeField("text", "searchInputListener")

    m.backButton = m.top.findNode("backButton")
    m.searchTitle = m.top.findNode("searchTitle")
    m.title = m.top.findNode("title")
    m.title.text = tr("Filmes e Séries")
    m.searchTitle.text = tr("Pesquisar")
    m.backButton.text = tr("Voltar")
    m.backButton.observeField("buttonSelected", "backButtonListener")
end function

function searchInputListener()
    print m.searchInput.text
    searchVods(m.searchInput.text)
end function

function loadRefreshToken()
    m.authRefreshTokenTask = m.top.findNode("AuthRefreshTokenTask")
    m.authRefreshTokenTask.observeField("authResponseDTO", "refreshTokenListener")
    m.authRefreshTokenTask.control = "RUN"
end function

function refreshTokenListener()
    if m.authRefreshTokenTask <> invalid
        response = ParseJson(m.authRefreshTokenTask.authResponseDTO)
        print("Status: " + response.status)
        if response.status = "ok"
            print("Refreshing token...")
            user = getUserFromSection()
            print("Current token: " + user.token)
            print("New token: " + response.data.token)
            user.token = response.data.token
            user.economic = response.data.economic
            user.expire = response.data.expire
            user.lifetime = response.data.lifetime
            user.parental = response.data.parental
            user.parpass = response.data.parpass
            user.rating = response.data.rating
            user.svod = response.data.svod
            user.validated_email = response.data.validated_email
            setUserOnSection(FormatJson(user))
            print("Token refreshed.")
        else
            print("Removing user from section.")
            print(response.msg)
            deleteUserOnSection()
            print("Redirecting user to ProviderSelectionScene.")
            redirectScreenTo("ProviderSelectionScene")
        end if
    end if

end function

function RowListVODsListener() as dynamic
    if m.GridSearchVodTask.content = invalid
        print "invalid GridSearchVodTask.content"
        return invalid
    end if

    m.vodZoomRowList.content = m.GridSearchVodTask.content
    m.vodZoomRowList.visible = true
end function

function searchVods(query as string)
    if query = "" then return invalid
    m.VODSearchTask = m.top.findNode("VODSearchTask")
    m.VODSearchTask.token = m.user.token
    m.VODSearchTask.username = m.user.username
    m.VODSearchTask.query = query
    m.VODSearchTask.providerURL = m.providerURL
    m.VODSearchTask.observeField("VODSearchResponseDTO", "searchVodsListener")
    m.VODSearchTask.control = "RUN"
end function

function searchVodsListener()
    if m.VODSearchTask.VODSearchResponseDTO = invalid then return invalid
    if m.VODSearchTask.VODSearchResponseDTO.haserror then return invalid
    renderSearchGrid(m.VODSearchTask.VODSearchResponseDTO.data)
end function

function renderSearchGrid(data)
    m.GridSearchVodTask = createObject("roSGNode", "GridSearchVodTask")
    m.GridSearchVodTask.GridSearchVodDTO = data
    m.GridSearchVodTask.observeField("content", "searchGridListener")
    m.GridSearchVodTask.control = "RUN"
end function

function searchGridListener()
    if m.GridSearchVodTask.content = invalid
        return invalid
    end if
    m.vodGridList = m.top.findNode("vodGridList")
    m.vodGridList.content = m.GridSearchVodTask.content
    m.vodGridList.unobserveField("itemSelected")
    m.vodGridList.observeField("itemSelected", "vodSelectedListener")
end function

function vodSelectedListener()
    selectedVODNode = m.vodGridList.content.getChild(m.vodGridList.itemSelected)
    selectedVOD = selectedVODNode.title
    setVodName(selectedVOD)
    redirectScreenTo("VodInternalScene")
end function

function buttonSelectedOnDialog()
    if m.top.getParent().dialog.buttonSelected = 0
        redirectScreenTo("VodsScene")
    else
        m.top.getParent().dialog.close = true
    end if
end function

function backButtonListener()
    redirectScreenTo("VodsScene")
end function

function itemSelected()
    row = m.vodZoomRowList.content.getChild(m.vodZoomRowList.rowItemSelected[0])
    selectedVod = row.getChild(m.vodZoomRowList.rowItemSelected[1])
    setVodName(selectedVod.title)
    redirectScreenTo("VodInternalScene")
end function

function shouldFocusKeyboardExistingRowList(key as string) as boolean
    if m.vodGridList = invalid then return false
    return (key = "back" or key = "left") and m.vodGridList.hasFocus()
end function

function shouldFocusRowListExistingRowList(key as string) as boolean
    if m.vodGridList = invalid then return false
    return key = "right"
end function

function shouldFocusBackButtonWhenKeyboardFocused(key as string) as boolean
    return key = "down" or key = "back"
end function

function shouldExitWhenBackButtonIsFocused(key as string) as boolean
    return key = "back" and m.backButton.hasFocus()
end function


function onKeyEvent(key as string, press as boolean) as boolean
    print "in VodSearchScene.xml onKeyEvent ";key;" "; press
    handled = false
    if press
        if shouldFocusKeyboardExistingRowList(key)
            m.vodGridList.setFocus(false)
            m.searchInput.setFocus(true)
            handled = true
        else if shouldFocusRowListExistingRowList(key)
            m.searchInput.setFocus(false)
            m.vodGridList.setFocus(true)
            handled = true
        else if shouldExitWhenBackButtonIsFocused(key)
            ? "backbutton:"; m.backButton.hasFocus()
            backButtonListener()
            handled = true
        else if shouldFocusBackButtonWhenKeyboardFocused(key)
            m.searchInput.setFocus(false)
            m.backButton.setFocus(true)
            handled = true
        else if key = "up" and m.backButton.hasFocus()
            m.backButton.setFocus(false)
            m.searchInput.setFocus(true)
            handled = true
        end if
        handled = true
    else 
        handled = true
    end if

    return handled
end function
