sub init()
    m.top.functionName = "getChannelResponse"
end sub

sub getChannelResponse() as object
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)
    request.SetUrl("https://" + m.top.providerURL + "/channels/" + m.top.channelId + "?t=" + m.top.token)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()
    if (request.AsyncGetToString())
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            if (code = 200)
                response = ParseJSON(msg.GetString())
                channelDTO = {
                    aonly: response.aonly,
                    categories: response.categories,
                    dash: response.dash,
                    desc: response.desc,
                    guide: response.guide,
                    health: response.health,
                    hls: response.hls,
                    id: response.id,
                    live: response.live,
                    logo: response.logo,
                    name: response.name,
                    number: response.number,
                    poster: response.poster
                    rating: response.rating,
                    startTime: response.startTime,
                    status: response.status,
                    switchingSensibility: response.switchingSensibility,
                    uid: response.uid
                }
            end if
            m.top.channelDTO = FormatJson(channelDTO)
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
    return invalid
end sub
