sub init()
    m.top.functionName = "getChannelsResponse"
end sub


function getAvailablePosters()
    return ["o1ch1", "o1ch4", "o1ch6", "o1ch8", "o1ch9", "o1ch11", "o1ch12", "o1ch14", "o1ch15", "o1ch16",
        "o1ch17", "o1ch18", "o1ch19", "o1ch20", "o1ch21", "o1ch23", "o1ch24", "o1ch25", "o1ch26", "o1ch27", "o1ch28",
    "o18556ch36", "o2ch54", "o1ch29", "o2ch56", "BZfJAdG", "BZfJAdK", "BZfJAde", "BZfJAde0", "BZfJAde1", "BZfJAde2", "BZfJAde3", "BZfJAde4", "BZfJAde5", "BZfJAdeX", "BZfJAdeY", "BZfJAdi0", "BZfJAdi1", "BZfJAdi2", "BZfJAdi3", "BZfJAdi4", "BZfJAdi5", "BZfJAdiW", "BZfJAdiX", "BZfJAdiZ", "BZfJAdq", "BZfJAdy"]
end function

function containsUID(uid as string) as boolean
    for each posterUID in getAvailablePosters()
        if posterUID = uid
            return true
        end if
    end for

    return false
end function

function populatePosters(channel) as void
    if channel.poster = "" or channel.poster = invalid:
        if containsUID(channel.uid)
            channel.poster = "https://s2.cdn.tv.br/new-layout/poster/" + channel.uid + ".png_352_198"
        else
            channel.poster = "https://s2.cdn.tv.br/new-layout/poster/default.png_352_198"
        end if
    else
        channel.poster = "https://" + m.top.providerURL + channel.poster + "_352_198"
    end if
end function

sub getChannelsResponse() as object
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)
    request.SetUrl("https://" + m.top.providerURL + "/channels?t=" + m.top.token)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()
    if (request.AsyncGetToString())
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            channelsListDTO = CreateObject("roArray", 10, true)
            if (code = 200)
                print "/channels status=" + StrI(code)
                channelsResponse = ParseJSON(msg.GetString())
                for each channel in channelsResponse
                    populatePosters(channel)
                    if channel.logo = invalid then channel.logo = ""

                    channelDTO = {
                        aonly: channel.aonly,
                        categories: channel.categories,
                        dash: channel.dash,
                        desc: channel.desc,
                        guide: channel.guide,
                        health: channel.health,
                        hls: channel.hls,
                        id: channel.id,
                        live: channel.live,
                        logo: "https://" + m.top.providerURL + channel.logo,
                        name: channel.name,
                        number: channel.number,
                        poster: channel.poster
                        rating: channel.rating,
                        startTime: channel.startTime,
                        status: channel.status,
                        switchingSensibility: channel.switchingSensibility,
                        uid: channel.uid
                    }

                    channelsListDTO.push(channelDTO)
                end for
            end if
            m.top.channelsListDTO = channelsListDTO
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
    return invalid
end sub
