sub init()
    m.top.functionName = "getIsEmailConfirmedResponse"
end sub

sub getIsEmailConfirmedResponse() as string
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)

    isEmailConfirmedRequestDTO = {
        token: m.top.token,
        providerURL: m.top.providerURL,
    }

    url = "https://" + isEmailConfirmedRequestDTO.providerURL + "/email/confirmation?t=" + isEmailConfirmedRequestDTO.token
    request.SetUrl(url)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()
    if (request.AsyncGetToString())
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()

            isEmailConfirmedResponseDTO = {
                status: "ok",
                data: {
                    isConfirmed: code = 200
                },
            }

            m.top.isEmailConfirmedResponseDTO = FormatJson(isEmailConfirmedResponseDTO)
            return m.top.isEmailConfirmedResponseDTO
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
end sub
