sub init()
    m.top.functionName = "perform"
end sub


sub perform() as object
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)
    request.SetUrl(m.top.providersListURL)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    if (request.AsyncGetToString())
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            if (code = 200)
                providersListDTO = CreateObject("roArray", 10, true)
                providersResponse = ParseJSON(msg.GetString())
                for each provider in providersResponse
                    providerDTO = {
                        edge: provider.edge
                        origin: provider.origin
                        name: provider.name
                    }
                    providersListDTO.push(providerDTO)
                end for
                m.top.providersListDTO = providersListDTO
            end if
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
    return invalid
end sub