function init()
    m.top.functionName = "perform"
end function

function VODDetailsRequestDTO(providerURL, email, vodName, user)
    return {
        providerURL: providerURL
        email: email
        vodName: vodName,
        user: user
    }
end function

function VODDetailsResponseDTO(data, status, msg)
    return {
        data: data, ' DTO | invalid
        status: status, ' "SUCCESS" | "NOT_FOUND"
        msg: msg ' :string
    }
end function

function perform()
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    m.VODDetailsRequestDTO = VODDetailsRequestDTO(m.top.providerURL, m.top.email, m.top.vodName, m.top.user)
    request.SetMessagePort(port)
    request.SetUrl("https://" + m.VODDetailsRequestDTO.providerURL + "/app/metadata/" + m.VODDetailsRequestDTO.email + "/1/" + m.VODDetailsRequestDTO.vodName)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()
    if (request.AsyncGetToString())
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            responseText = msg.GetString()
            if (isResponseInvalid(code, responseText))
                m.top.VODDetailsDTO = VODDetailsResponseDTO(invalid, "NOT_FOUND", "The given VOD " + m.VODDetailsRequestDTO.vodName + " was not found!")
                return invalid
            end if
            VODDetailsResponse = parseJSON(msg.GetString())
            VODDetailsDTO = VODDetailsResponseMapper(VODDetailsResponse)
            m.top.VODDetailsDTO = VODDetailsResponseDTO(VODDetailsDTO, "SUCCESS", "VOD founded sucessfully!")
            return invalid
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
    return invalid
end function

function isResponseInvalid(code, responseText)
    print "responseText="; responseText
    print "code="; code
    return code <> 200 or responseText = "null" or responseText = invalid
end function

function VODDetailsResponseMapper(response)
    details = {}

    if isMultimedia(response)
        multimedia = MultimediaDTO(response)
        details = MultimediaDetailsDTOMapper(multimedia)
    else
        singlemedia = SinglemediaDTO(response)
        details = SinglemediaDetailsDTOMapper(singlemedia)
    end if
    print "details"; details
    return details

end function

function DetailsDTO(title, releaseYear, genres, seasons, duration, poster, synopsis, vodType, selling, seasonsList, playlist, vodName, watching_time, ageRating, price) as object
    return {
        duration: duration,
        genres: genres,
        playlist: playlist,
        poster: poster,
        releaseYear: releaseYear,
        seasons: seasons,
        seasonsList: seasonsList,
        selling: selling,
        synopsis: synopsis,
        title: title,
        vodType: vodType,
        vodName: vodName,
        watching_time: watching_time
        ageRating: ageRating,
        price: price
    }
end function

function isMultimedia(response) as boolean
    if response.seasons <> invalid then return true
    return false
end function

function MultimediaDTO(response)
    return {
        idMultimedia: response.idMultimedia,
        originalTitle: response.originalTitle,
        portugueseTitle: response.portugueseTitle,
        category: response.category,
        year: response.year,
        originalLanguage: response.originalLanguage,
        ageRating: response.ageRating,
        synopsis: response.synopsis,
        synopsisSummary: response.synopsisSummary,
        audio: response.audio,
        subtitled: response.subtitled,
        studio: response.studio,
        countryOrigin: response.countryOrigin,
        casts: response.casts,
        directors: response.directors,
        genres: response.genres,
        seasons: VODSeasonListDTOMapper(response)
    }
end function

function SinglemediaDTO(response)
    return {
        name: response.name,
        path: response.path,
        createdAt: response.createdAt,
        updatedAt: response.updatedAt,
        size: response.size,
        quarantine: response.quarantine,
        available: response.available,
        commercial_charge: response.commercial_charge,
        video_duration: response.video_duration,
        idMultimedia: response.idMultimedia,
        metadata: metadataDTOMapper(response.metadata),
        multimedia: response.multimedia,
        selling: response.selling,
        ageRating: response.ageRating,
        playlist: response.playlist
        watching_time: response.watching_time
    }
end function

function getWatchingTimeByName(multimedia, name)
    watching_time = 0

    for each season in multimedia.seasons
        for each episode in season.episodes
            if episode.vod.name = name
                watching_time = episode.vod.watching_time
            end if
        end for
    end for

    if IsString(watching_time) then watching_time = watching_time.ToInt()
    return watching_time
end function

function MultimediaDetailsDTOMapper(multimedia)
    posterUrl = "https://" + m.top.providerURL + "/images/" + m.VODDetailsRequestDTO.vodName + "_poster.jpg_280_280"
    genres = multimedia.genres.join(", ")
    watching_time = getWatchingTimeByName(multimedia, m.VODDetailsRequestDTO.vodName)

    return DetailsDTO(multimedia.portugueseTitle, multimedia.year, genres, multimedia.seasons.count(), 0, posterUrl, multimedia.synopsis, "MULTIMEDIA", false, multimedia.seasons, "", "", watching_time, "", "")
end function

function SinglemediaDetailsDTOMapper(singlemedia)
    posterUrl = "https://" + m.top.providerURL + "/images/" + m.VODDetailsRequestDTO.vodName + "_poster.jpg_280_280"
    genres = genresJoined(singlemedia.metadata.genres)
    duration = GetDurationString(singlemedia.video_duration.ToInt())
    if IsString(singlemedia.watching_time) then singlemedia.watching_time = singlemedia.watching_time.ToInt()
    return DetailsDTO(singlemedia.metadata.portugueseTitle, singlemedia.metadata.year, genres, 0, duration, posterUrl, singlemedia.metadata.synopsis, "SINGLEMEDIA", singlemedia.selling, [], singlemedia.playlist, singlemedia.name, singlemedia.watching_time, singlemedia.metadata.ageRating, singlemedia.commercial_charge)
end function

function genresJoined(genres) as string
    text = []

    for each genre in genres
        text.push(genre.name)
    end for

    return text.join(", ")
end function

function VODMediaDTOMapper(response)
    return {
        available: response.available,
        category: response.category,
        commercial_charge: response.commercial_charge,
        genres: response.genres,
        metadata: metadataDTOMapper(response.metadata),
        multimedia: response.multimedia,
        name: response.name,
        playlist: response.playlist,
        portugueseTitle: response.portugueseTitle,
        poster: "https://" + m.top.providerURL + "/images/" + response.name + "_poster.jpg",
        seasons: response.seasons,
        selling: response.selling,
        size: response.size,
        subtitles: response.subtitles,
        synopsis: response.synopsis,
        updatedAt: response.updatedAt,
        video_duration: response.video_duration,
        watching_time: response.watching_time,
        year: response.year,
    }
end function

function VODSeasonListDTOMapper(response)
    seasonListDTO = []

    for each season in response.seasons.Items()
        seasonDTO = {
            number: season.key,
            episodes: []
        }

        seasonDTO.episodes = VODEpisodeListDTOMapper(season.value)

        seasonListDTO.push(seasonDTO)
    end for

    return seasonListDTO
end function

function VODEpisodeListDTOMapper(episodes)
    episodeListDTO = []

    for each episode in episodes.Items()
        episodeDTO = {
            number: episode.key,
            vod: {}
        }

        episodeDTO.vod = VODMediaDTOMapper(episode.value)

        episodeListDTO.push(episodeDTO)
    end for

    return episodeListDTO
end function

function metadataDTOMapper(metadata)
    return {
        id: metadata?.id,
        episodeNumber: metadata?.episodeNumber,
        genres: genresMapperDTO(metadata?.genres),
        originalLanguage: metadata?.originalLanguage,
        originalTitle: metadata?.originalTitle,
        portugueseTitle: metadata?.portugueseTitle,
        portugueseTitleEpisode: metadata?.portugueseTitleEpisode,
        season: metadata?.season,
        ageRating: metadata?.ageRating,
        synopsis: metadata?.synopsis,
        synopsisSummary: metadata?.synopsisSummary,
        year: metadata?.year
    }

end function

function genresMapperDTO(genres)
    genresListDTO = []

    for each genre in genres
        genreDTO = {
            id: genre.id,
            name: genre.name
        }

        genresListDTO.push(genreDTO)
    end for

    return genresListDTO
end function

function comercialVersionsMapper(commercialVersions)
    commercialVersionsListDTO = []

    for each comercialVersion in commercialVersions

        commercialVersionsDTO = {
            id: comercialVersion.id,
            billingId: comercialVersion.billingId,
            channel: comercialVersion.channel,
            charge: comercialVersion.charge,
            endDate: comercialVersion.endDate,
            product: comercialVersion.product,
            startDate: comercialVersion.startDate,
        }

        commercialVersionsListDTO.push(commercialVersionsDTO)
    end for

    return commercialVersionsListDTO
end function

' Helper
function GetDurationString(totalSeconds = 0 as integer) as string
    remaining = totalSeconds
    hours = Int(remaining / 3600).ToStr()
    remaining = remaining mod 3600
    minutes = Int(remaining / 60).ToStr()
    remaining = remaining mod 60
    seconds = remaining.ToStr()

    if hours <> "0" then
        return PadLeft(hours, "0", 2) + ":" + PadLeft(minutes, "0", 2) + ":" + PadLeft(seconds, "0", 2)
    else
        return PadLeft(minutes, "0", 2) + ":" + PadLeft(seconds, "0", 2)
    end if
end function

function PadLeft(value as string, padChar as string, totalLength as integer) as string
    while value.Len() < totalLength
        value = padChar + value
    end while
    return value
end function

function IsString(value as dynamic) as boolean
    return IsValid(value) and GetInterface(value, "ifString") <> invalid
end function

function IsValid(value as dynamic) as boolean
    return Type(value) <> "<uninitialized>" and value <> invalid
end function